#!/usr/bin/perl -T

# Version 6.0.1
#
# This script attempts to add a printer filter called pdf to the cups system, restart the
# cups daemon so it recognizes that filter, then add a queue based on that filter.
# The end result should be an Adobe PDF printer appearing in the Print Center Printer List,
# with Kind of Adobe PDF 3015.102.
#
# the procedure used is this (psuedo-code):
#
# 1. Try to add the queue.
# 2. Check to see if we've been successful, and print an error message if not.
#
# Change the 0 in this statement to 1 to get debug printouts while executing. Change it back to 0 when done.
#    
$debug = 0;

# added to run in secure environment
$ENV{'PATH'} = '/bin:/usr/bin';  #or whatever you need
$ENV{'SHELL'} = '/bin/sh' if $ENV{'SHELL'} ne '';
$ENV{'IFS'} = '' if $ENV{'IFS'} ne '';
#end of added code.

if (-e "/usr/libexec/cups/backend/pdf700")
{
	`/usr/sbin/lpadmin -p 'AdobePDF7' -v pdf700://distiller/ -P /Library/Printers/PPDs/Contents/Resources/en.lproj/ADPDF7.PPD -E -D 'Adobe PDF 7.0'`;
	$err = $?;
	
	if ($err == 0) 
	{
		print "Successfully added AdobePDF printer on $i iteration.\n" if ($debug == 1);
		$foundit = 1;
	}
}	
print "Couldn't add the AdobePDF printer.\n" if ($foundit == 0);
